unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure ListBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListBox2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormResize(Sender: TObject);
begin
ListBox1.Width:=ClientWidth div 2;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i :Integer;
begin
for i:=0 to 9 do
    begin
    ListBox1.Items.Add('Lista 1 : '+IntToStr(i));
    ListBox2.Items.Add('Lista 2 : '+IntToStr(i));
    end;
end;


procedure TForm1.ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  SenderLB :TListBox;
begin
SenderLB:=Sender as TListBox;

if (Button=mbLeft) and (SenderLB.ItemIndex>=0) then
  SenderLB.BeginDrag(false);
end;

procedure TForm1.ListBox2DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
Accept:=false;
if (Source<>Sender) then
  Accept:=true;
end;

//dodawanie na koncu
procedure TForm1.ListBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
var SenderLB,SourceLB :TListBox;
begin
SenderLB:=Sender as TListBox;
SourceLB:=Source as TListBox;

SenderLB.Items.Add(SourceLB.Items.Strings[SourceLB.ItemIndex]);
SourceLB.Items.Delete(SourceLB.ItemIndex);
end;

end.
